#include <bits/stdc++.h>
using namespace std;

typedef long long ll;
const ll INF = 100005;

ll num[INF], a[INF], used[INF];
ll n, m, k1, k2;
vector <ll> roads[INF], ans;
queue <ll> q;

void CheckStupidDfs(ll we){
    if(used[we] == 1) return;
    used[we] = 1;
    for(auto x : roads[we]){
        CheckStupidDfs(x);
    }
    return;
}


bool Ask(){
    for(int i=1; i <= n; i++){
        if(used[i] != 1) return false;
    }
    return true;
}

bool dfs(ll we, ll par){
    if(we == 1 && used[we] == 1){
        return Ask();
    }
    if(used[we] == 1) return false;
    used[we] = 1;

    q.push(we);
    bool is;

    for(auto x : roads[we]){
        if(x != par) is = dfs(x, we);

        if(is == true) return true;
        else{
            while(q.front() != we){
                used[q.front()] = 0;
                q.pop();
            }
        }
    }
    return false;
}


int main()
{
    cin >> n >> m;
    for(int i=1; i <= m; i++){
        cin >> k1 >> k2;
        roads[k1].push_back(k2);
        //roads[k2].push_back(k1);
    }
    for(int i=1; i <= n; i++) used[i] = 0;
    CheckStupidDfs(1);
    for(int i=1; i <= n; i++){
        if(used[i] != 1){
            cout << "NO" << endl;
            return 0;
        }
        used[i] = 0;
    }

    if(dfs(1, -1) == false){
        cout << "NO" << endl;
        return 0;
    }
    cout << "YES" << endl;

    while(!q.empty()){
        ans.push_back(q.front());
        q.pop();
    }
    reverse(ans.begin(), ans.end());
    for(auto x : ans){
        cout << x << " ";
    }
    cout << endl;

    return 0;
}
